/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import de.maxhenkel.voicechat.gui.widgets.MicTestButton;
import de.maxhenkel.voicechat.natives.RNNoiseManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.common.AudioUtils;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class VoiceActivationSlider
extends DebouncedSlider
implements MicTestButton.MicListener {
    private static final ResourceLocation SLIDER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider");
    private static final ResourceLocation HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_highlighted");
    private static final ResourceLocation SLIDER_HANDLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle");
    private static final ResourceLocation SLIDER_HANDLE_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle_highlighted");
    private static final ResourceLocation VOICE_ACTIVATION_SLIDER = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/gui/voice_activation_slider.png");
    private static final Component NO_ACTIVATION = Component.translatable((String)"message.voicechat.voice_activation.disabled").withStyle(ChatFormatting.RED);
    private final SlidingMaxSmooth micValue;

    public VoiceActivationSlider(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.empty(), AudioUtils.dbToPerc(VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.get().floatValue()));
        this.updateMessage();
        this.micValue = new SlidingMaxSmooth();
    }

    public boolean shouldShowSlider() {
        if (!MicrophoneActivationType.VOICE.equals((Object)VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get())) {
            return false;
        }
        if (!RNNoiseManager.canUseDenoiser()) {
            return true;
        }
        return VoicechatClient.CLIENT_CONFIG.vad.get() == false;
    }

    public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        guiGraphics.blitSprite(this.getSlider(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        int micWidth = (int)((double)(this.width - 2) * this.micValue.smoothMax());
        guiGraphics.blit(VOICE_ACTIVATION_SLIDER, this.getX() + 1, this.getY() + 1, 0, 0, micWidth, 18);
        this.active = this.shouldShowSlider();
        if (!this.active) {
            return;
        }
        guiGraphics.blitSprite(this.getHandle(), this.getX() + (int)(this.value * (double)(this.width - 8)), this.getY(), 8, 20);
        this.renderScrollingString(guiGraphics, minecraft.font, 2, 0xFFFFFF);
    }

    private ResourceLocation getSlider() {
        return this.isFocused() && !this.isHovered && !this.isFocused() ? HIGHLIGHTED_SPRITE : SLIDER_SPRITE;
    }

    private ResourceLocation getHandle() {
        return !this.isHovered && !this.isFocused() ? SLIDER_HANDLE_SPRITE : SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
    }

    protected void updateMessage() {
        long db = Math.round(AudioUtils.percToDb(this.value));
        MutableComponent component = Component.translatable((String)"message.voicechat.voice_activation", (Object[])new Object[]{db});
        if (db >= -10L) {
            component.withStyle(ChatFormatting.RED);
        }
        this.setMessage((Component)component);
    }

    @Nullable
    public Component getHoverText() {
        if (!this.active) {
            return null;
        }
        if (this.value >= 1.0) {
            return NO_ACTIVATION;
        }
        return null;
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    @Override
    public void applyDebounced() {
        VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.set(AudioUtils.percToDb(this.value)).save();
    }

    @Override
    public void onMicValue(double dB) {
        this.micValue.add(AudioUtils.dbToPerc(dB));
    }

    @Override
    public void onStop() {
        this.micValue.reset();
    }

    private static class SlidingMaxSmooth {
        private final double[] values = new double[15];
        private int n;
        private int p;
        private static final double SMOOTHING_PER_SEC = 25.0;
        private double smoothed;
        private long lastNs = -1L;

        private SlidingMaxSmooth() {
        }

        public void add(double x) {
            if (this.n < this.values.length) {
                ++this.n;
            }
            this.values[this.p] = x;
            this.p = (this.p + 1) % this.values.length;
        }

        public double max() {
            if (this.n == 0) {
                return 0.0;
            }
            int len = Math.min(this.n, this.values.length);
            double max = this.values[0];
            for (int i = 1; i < len; ++i) {
                if (!(this.values[i] > max)) continue;
                max = this.values[i];
            }
            return max;
        }

        public double smoothMax() {
            long nowNanos = System.nanoTime();
            double target = this.max();
            if (this.lastNs < 0L) {
                this.lastNs = nowNanos;
                this.smoothed = target;
                return this.smoothed;
            }
            double dt = (double)(nowNanos - this.lastNs) / 1.0E9;
            this.lastNs = nowNanos;
            double alpha = dt * 25.0;
            if (alpha > 1.0) {
                alpha = 1.0;
            }
            if (alpha < 0.0) {
                alpha = 0.0;
            }
            this.smoothed += (target - this.smoothed) * alpha;
            return this.smoothed;
        }

        public void reset() {
            this.n = 0;
            this.p = 0;
            this.smoothed = 0.0;
            this.lastNs = -1L;
        }
    }
}

