/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import sereneseasons.api.SSBlockEntities;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.block.entity.SeasonSensorBlockEntity;
import sereneseasons.init.ModConfig;
import sereneseasons.season.SeasonTime;

public class SeasonSensorBlock
extends BaseEntityBlock {
    public static final MapCodec<SeasonSensorBlock> CODEC = SeasonSensorBlock.simpleCodec(SeasonSensorBlock::new);
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    public static final IntegerProperty SEASON = IntegerProperty.create((String)"season", (int)0, (int)3);

    public SeasonSensorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)SEASON, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext selectionContext) {
        return SHAPE;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter reader, BlockPos pos, Direction direction) {
        return (Integer)state.getValue((Property)POWER);
    }

    public void updatePower(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (ModConfig.seasons.isDimensionWhitelisted((ResourceKey<Level>)world.dimension())) {
            BlockState currentState = world.getBlockState(pos);
            int power = 0;
            int startTicks = (Integer)currentState.getValue((Property)SEASON) * SeasonTime.ZERO.getSeasonDuration();
            int endTicks = ((Integer)currentState.getValue((Property)SEASON) + 1) * SeasonTime.ZERO.getSeasonDuration();
            int currentTicks = SeasonHelper.getSeasonState(world).getSeasonCycleTicks();
            if (currentTicks >= startTicks && currentTicks <= endTicks) {
                float delta = (float)(currentTicks - startTicks) / (float)SeasonTime.ZERO.getSeasonDuration();
                power = (int)Math.min(delta * 15.0f + 1.0f, 15.0f);
            }
            if ((Integer)currentState.getValue((Property)POWER) != power) {
                world.setBlock(pos, (BlockState)currentState.setValue((Property)POWER, (Comparable)Integer.valueOf(power)), 3);
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult rayTraceResult) {
        if (player.mayBuild()) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            BlockState blockstate = (BlockState)state.cycle((Property)SEASON);
            level.setBlock(pos, blockstate, 4);
            this.updatePower(level, pos);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, rayTraceResult);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SeasonSensorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide && level.dimensionType().hasSkyLight() ? SeasonSensorBlock.createTickerHelper(type, SSBlockEntities.SEASON_SENSOR, SeasonSensorBlock::tickEntity) : null;
    }

    private static void tickEntity(Level level, BlockPos pos, BlockState state, SeasonSensorBlockEntity entity) {
        Block block;
        if (level != null && !level.isClientSide && (long)SeasonHelper.getSeasonState(level).getSeasonCycleTicks() % 20L == 0L && (block = state.getBlock()) instanceof SeasonSensorBlock) {
            ((SeasonSensorBlock)block).updatePower(level, pos);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWER, SEASON});
    }
}

