/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.env.param;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.util.AdapterUtil;

public class MethodParameters {
    private final Map<ParamGroup, List<Type>> groups;
    private final List<ParamGroup> order;

    private MethodParameters(Map<ParamGroup, List<Type>> groups, List<ParamGroup> order) {
        this.groups = new HashMap<ParamGroup, List<Type>>(groups);
        this.order = order;
    }

    public List<Type> get(ParamGroup group) {
        return Objects.requireNonNull(this.groups.get(group), "Group %s is not available".formatted(group.name()));
    }

    public void set(ParamGroup group, List<Type> params) {
        if (!this.groups.containsKey(group)) {
            throw new IllegalArgumentException("Group %s is not available".formatted(group.name()));
        }
        this.groups.put(group, params);
    }

    public List<Type> merge() {
        ArrayList<Type> result = new ArrayList<Type>();
        for (ParamGroup group : this.order) {
            result.addAll((Collection<Type>)this.groups.get(group));
        }
        return result;
    }

    public static List<Type> getParameterTypes(String desc) {
        return Arrays.asList(Type.getArgumentTypes((String)desc));
    }

    private static List<ParamInfo> getParamInfo(MethodNode method) {
        List<Type> params = MethodParameters.getParameterTypes(method.desc);
        ArrayList<ParamInfo> infos = new ArrayList<ParamInfo>();
        for (int i = 0; i < params.size(); ++i) {
            infos.add(new ParamInfo(params.get(i), AdapterUtil.isParamAnnotated(method, i, "Lcom/llamalad7/mixinextras/sugar/Local;")));
        }
        return infos;
    }

    public static MethodParameters create(MethodNode method, List<ParamGroup> groups) {
        return MethodParameters.create(MethodParameters.getParamInfo(method), groups);
    }

    private static MethodParameters create(List<ParamInfo> params, List<ParamGroup> groups) {
        HashMap<ParamGroup, List<Type>> results = new HashMap<ParamGroup, List<Type>>();
        for (ParamGroup type : groups) {
            results.put(type, new ArrayList());
        }
        int groupIndex = 0;
        int paramIndex = 0;
        while (paramIndex < params.size() && groupIndex < groups.size()) {
            ParamGroup group = groups.get(groupIndex);
            ParamGroup nextGroup = groupIndex + 1 < groups.size() ? groups.get(groupIndex + 1) : null;
            ParamInfo param = params.get(paramIndex);
            List output = (List)results.get(group);
            if (group.type() == ParamGroupType.SINGLE) {
                if (!group.predicate().test(param)) {
                    throw new IllegalStateException("Unexpected single parameter: " + String.valueOf(param));
                }
                output.add(param.type());
                ++paramIndex;
                ++groupIndex;
                continue;
            }
            if (group.type() != ParamGroupType.VARIABLE) continue;
            if (group.predicate().test(param)) {
                if (nextGroup != null && nextGroup.predicate().test(param)) {
                    if (nextGroup.type() == ParamGroupType.SINGLE) {
                        ++groupIndex;
                        continue;
                    }
                    throw new IllegalStateException("Ambiguous match for param %s in groups %s and %s".formatted(param.type(), group.name(), groups.get(groupIndex + 1).name()));
                }
                output.add(param.type());
                ++paramIndex;
                continue;
            }
            ++groupIndex;
        }
        return new MethodParameters(results, groups);
    }

    public static Builder builder() {
        return new Builder();
    }

    public record ParamGroup(ParamGroupType type, String name, Predicate<ParamInfo> predicate) {
        public static final ParamGroup METHOD_PARAMS = new ParamGroup(ParamGroupType.VARIABLE, "method_params", i -> true);
        public static final ParamGroup CAPTURED_PARAMS = new ParamGroup(ParamGroupType.VARIABLE, "captured_params", i -> !i.isLocal());
        public static final ParamGroup SINGLE_ANY = new ParamGroup(ParamGroupType.SINGLE, "single_any", i -> true);
        public static final ParamGroup CI_CIR = new ParamGroup(ParamGroupType.SINGLE, "ci_cir", i -> i.type().equals((Object)AdapterUtil.CI_TYPE) || i.type().equals((Object)AdapterUtil.CIR_TYPE));
        public static final ParamGroup OPERATION = new ParamGroup(ParamGroupType.SINGLE, "operation", i -> i.type().equals((Object)AdapterUtil.OPERATION_TYPE));
        public static final ParamGroup LOCALS = new ParamGroup(ParamGroupType.VARIABLE, "locals", ParamInfo::isLocal);
    }

    public record ParamInfo(Type type, boolean isLocal) {
    }

    public static enum ParamGroupType {
        SINGLE,
        VARIABLE;

    }

    public static class Builder {
        private final Map<ParamGroup, List<Type>> groups = new HashMap<ParamGroup, List<Type>>();
        private final List<ParamGroup> order = new ArrayList<ParamGroup>();

        public Builder put(ParamGroup group, Type param) {
            return this.put(group, List.of(param));
        }

        public Builder put(ParamGroup group, List<Type> params) {
            if (this.order.contains(group)) {
                throw new IllegalStateException("Duplicate group " + String.valueOf(group));
            }
            this.groups.put(group, new ArrayList<Type>(params));
            this.order.add(group);
            return this;
        }

        public MethodParameters build() {
            return new MethodParameters(this.groups, this.order);
        }
    }
}

