/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.pipeline.resolver;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.sinytra.adapter.next.env.MixinContext;
import org.sinytra.adapter.next.env.ann.MixinData;
import org.sinytra.adapter.next.pipeline.Recipe;
import org.sinytra.adapter.next.pipeline.TxResultInstance;
import org.sinytra.adapter.next.pipeline.config.Configuration;
import org.sinytra.adapter.next.pipeline.resolver.Resolver;
import org.sinytra.adapter.next.pipeline.resolver.SubResolver;

public abstract class CompoundResolver
implements Resolver {
    protected final List<SubResolver> subResolvers = new ArrayList<SubResolver>();

    public void addSubResolver(SubResolver subResolver) {
        this.subResolvers.add(subResolver);
    }

    protected abstract boolean canApply(MixinData var1, Configuration var2, Configuration var3);

    @Nullable
    protected Configuration tryReuse(MixinContext context, Configuration clean, Configuration dirty) {
        return null;
    }

    @Nullable
    protected Configuration useFallback(MixinContext context, Configuration clean, Configuration dirty) {
        return null;
    }

    @Override
    public TxResultInstance resolve(MixinData mixin, MixinContext context, Configuration clean, Configuration dirty, Recipe recipe) {
        if (!this.canApply(mixin, clean, dirty)) {
            return TxResultInstance.pass();
        }
        Configuration resused = this.tryReuse(context, clean, dirty);
        if (resused != null) {
            return TxResultInstance.success(resused);
        }
        for (SubResolver subResolver : this.subResolvers) {
            Configuration result = subResolver.resolve(mixin, context, clean, dirty, recipe);
            if (result == null) continue;
            return TxResultInstance.success(result);
        }
        Configuration fallback = this.useFallback(context, clean, dirty);
        if (fallback != null) {
            return TxResultInstance.success(fallback);
        }
        return TxResultInstance.fail();
    }
}

