/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.pipeline.resolver.injection;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.next.env.MixinContext;
import org.sinytra.adapter.next.env.ann.MixinData;
import org.sinytra.adapter.next.env.ann.ModifyVariableMixinData;
import org.sinytra.adapter.next.pipeline.Recipe;
import org.sinytra.adapter.next.pipeline.config.Configuration;
import org.sinytra.adapter.next.pipeline.resolver.SubResolver;
import org.sinytra.adapter.patch.analysis.InstructionMatcher;
import org.sinytra.adapter.patch.analysis.locals.LocalVarAnalyzer;
import org.sinytra.adapter.patch.analysis.locals.LocalVariableLookup;
import org.sinytra.adapter.patch.api.MethodContext;

public class ModifyVarInjectionPointSubResolver
implements SubResolver {
    @Override
    @Nullable
    public Configuration resolve(MixinData mixin, MixinContext context, Configuration clean, Configuration dirty, Recipe recipe) {
        ModifyVariableMixinData mvdata;
        block3: {
            block2: {
                if (!(mixin instanceof ModifyVariableMixinData)) break block2;
                mvdata = (ModifyVariableMixinData)mixin;
                if (clean.getAtData().getValue().equals("STORE")) break block3;
            }
            return null;
        }
        MethodContext.TargetPair pair = context.methods().findOwnMethodPair(context.dirtyLookup(), dirty.getTargetMethod());
        return ModifyVarInjectionPointSubResolver.findComparableReplacement(mvdata, context, clean, pair, dirty);
    }

    private static Configuration findComparableReplacement(ModifyVariableMixinData mixin, MixinContext context, Configuration clean, MethodContext.TargetPair dirtyPair, Configuration dirty) {
        if (mixin.ordinal().isEmpty()) {
            return null;
        }
        int ordinal = mixin.ordinal().getAsInt();
        Type varType = Type.getReturnType((String)context.methodNode().desc);
        MethodContext.TargetPair cleanPair = context.methods().findOwnMethodPair(context.cleanLookup(), clean.getTargetMethod());
        LocalVariableLookup lookup = new LocalVariableLookup(cleanPair.methodNode());
        LocalVariableNode desired = lookup.getByTypedOrdinal(varType, ordinal).orElseThrow();
        InsnList desiredInitializerInsns = LocalVarAnalyzer.findInitializerInsns(cleanPair.methodNode(), desired.index);
        for (MethodNode method : dirtyPair.classNode().methods) {
            LocalVariableLookup dirtyLookup = new LocalVariableLookup(method);
            List<LocalVariableNode> lvs = method.localVariables.stream().filter(lvn -> desired.desc.equals(lvn.desc)).filter(lvn -> {
                InsnList insns = LocalVarAnalyzer.findInitializerInsns(method, lvn.index);
                return InstructionMatcher.test(desiredInitializerInsns, insns);
            }).toList();
            if (lvs.size() != 1) continue;
            int dirtyOrdinal = dirtyLookup.getOrdinal(lvs.getFirst());
            return dirty.subConfig().setProperty("ordinal", dirtyOrdinal).setTargetMethod(method).inheritAtData();
        }
        return null;
    }
}

