/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.analysis.params;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.params.LayeredParamsDiffSnapshot;
import org.sinytra.adapter.patch.analysis.params.ParametersDiff;
import org.sinytra.adapter.patch.analysis.params.ParamsDiffSnapshotBuilder;
import org.sinytra.adapter.patch.analysis.params.SimpleParamsDiffSnapshot;
import org.sinytra.adapter.patch.util.GeneratedVariables;
import org.slf4j.Logger;

public class EnhancedParamsDiff {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean DEBUG = Boolean.getBoolean("adapter.definition.paramdiff.debug");

    public static SimpleParamsDiffSnapshot create(Type[] clean, Type[] dirty) {
        return EnhancedParamsDiff.create(List.of(clean), List.of(dirty));
    }

    public static SimpleParamsDiffSnapshot create(List<Type> clean, List<Type> dirty) {
        SimpleParamsDiffSnapshot.Builder builder = SimpleParamsDiffSnapshot.builder();
        EnhancedParamsDiff.buildDiff(builder, clean, dirty);
        return builder.build();
    }

    public static LayeredParamsDiffSnapshot createLayered(List<Type> clean, List<Type> dirty) {
        LayeredParamsDiffSnapshot.Builder builder = LayeredParamsDiffSnapshot.builder();
        EnhancedParamsDiff.buildDiff(builder, clean, dirty);
        return builder.build();
    }

    public static LayeredParamsDiffSnapshot compareMethodParameters(MethodNode clean, MethodNode dirty) {
        if (clean.localVariables == null || dirty.localVariables == null) {
            return LayeredParamsDiffSnapshot.EMPTY;
        }
        int cleanParamCount = Type.getArgumentTypes((String)clean.desc).length;
        int dirtyParamCount = Type.getArgumentTypes((String)dirty.desc).length;
        boolean isCleanStatic = (clean.access & 8) == 8;
        boolean isDirtyStatic = (dirty.access & 8) == 8;
        List<LocalVariable> cleanParams = clean.localVariables.stream().sorted(Comparator.comparingInt(lv -> lv.index)).filter(lv -> isCleanStatic || lv.index != 0).limit(cleanParamCount).map(LocalVariable::new).toList();
        List<LocalVariable> dirtyParams = dirty.localVariables.stream().sorted(Comparator.comparingInt(lv -> lv.index)).filter(lv -> isDirtyStatic || lv.index != 0).limit(dirtyParamCount).map(LocalVariable::new).toList();
        boolean compareNames = cleanParams.stream().allMatch(t -> t.name() != null) && dirtyParams.stream().anyMatch(LocalVariable::isGenerated);
        LayeredParamsDiffSnapshot.Builder builder = LayeredParamsDiffSnapshot.builder();
        EnhancedParamsDiff.buildDiffWithContext(builder, EnhancedParamsDiff.createPositionedVariableList(cleanParams), EnhancedParamsDiff.createPositionedVariableList(dirtyParams), compareNames);
        return builder.build();
    }

    private static void buildDiff(ParamsDiffSnapshotBuilder builder, List<Type> clean, List<Type> dirty) {
        EnhancedParamsDiff.buildDiffWithContext(builder, EnhancedParamsDiff.createPositionedList(clean), EnhancedParamsDiff.createPositionedList(dirty), false);
    }

    private static void buildDiffWithContext(ParamsDiffSnapshotBuilder builder, List<TypeWithContext> cleanQueue, List<TypeWithContext> dirtyQueue, boolean compareNames) {
        boolean sameSize;
        int dirtySize = dirtyQueue.size();
        boolean bl = sameSize = cleanQueue.size() == dirtyQueue.size();
        if (DEBUG) {
            LOGGER.info("Comparing types:\n{}", (Object)EnhancedParamsDiff.printTable(cleanQueue, dirtyQueue));
        }
        while (!cleanQueue.isEmpty()) {
            int dirtyTypeIndex;
            if (EnhancedParamsDiff.predictParameterMatch(builder, cleanQueue, dirtyQueue, compareNames, sameSize)) {
                cleanQueue.removeFirst();
                dirtyQueue.removeFirst();
                continue;
            }
            if (EnhancedParamsDiff.tryReplacingParams(builder, cleanQueue, dirtyQueue)) continue;
            SwapResult swapResult = EnhancedParamsDiff.checkForSwaps(builder, cleanQueue, dirtyQueue);
            if (swapResult != null) {
                dirtyQueue.removeAll(swapResult.removeDirty());
                cleanQueue.clear();
                dirtyQueue.clear();
                break;
            }
            int n = dirtyTypeIndex = cleanQueue.size() == 1 ? dirtySize - 1 : EnhancedParamsDiff.lookAhead(dirtyQueue, cleanQueue.get(1));
            if (dirtyTypeIndex != -1) {
                boolean matchesName = !compareNames || cleanQueue.size() < 2 || dirtyQueue.size() < 2 || cleanQueue.get(1).matches(dirtyQueue.get(1));
                int offset = cleanQueue.get(0).sameType(dirtyQueue.get(0)) && matchesName ? 1 : 2;
                List<TypeWithContext> compareClean = EnhancedParamsDiff.extract(cleanQueue, matchesName ? 2 : 1);
                List<TypeWithContext> compareDirty = EnhancedParamsDiff.extract(dirtyQueue, dirtyTypeIndex + offset);
                EnhancedParamsDiff.compare(builder, compareClean, compareDirty);
                continue;
            }
            if (cleanQueue.size() == dirtyQueue.size() && (dirtyTypeIndex = EnhancedParamsDiff.findClosestMatch(cleanQueue, dirtyQueue)) > 1) {
                List<TypeWithContext> compareClean = EnhancedParamsDiff.extract(cleanQueue, dirtyTypeIndex);
                List<TypeWithContext> compareDirty = EnhancedParamsDiff.extract(dirtyQueue, dirtyTypeIndex);
                EnhancedParamsDiff.compare(builder, compareClean, compareDirty);
                continue;
            }
            if (cleanQueue.size() > 1) {
                TypeWithContext type = cleanQueue.remove(1);
                if (DEBUG) {
                    LOGGER.info("Removing type {}", (Object)type);
                }
                builder.remove(type.pos());
                continue;
            }
            throw new IllegalStateException("undefined behavior");
        }
        if (!dirtyQueue.isEmpty()) {
            for (TypeWithContext type : dirtyQueue) {
                builder.insert(type.pos(), type.type());
            }
        }
    }

    private static boolean predictParameterMatch(ParamsDiffSnapshotBuilder builder, List<TypeWithContext> cleanQueue, List<TypeWithContext> dirtyQueue, boolean compareNames, boolean sameSize) {
        if (sameSize && !cleanQueue.isEmpty() && !dirtyQueue.isEmpty()) {
            if (!cleanQueue.get(0).sameType(dirtyQueue.get(0))) {
                if (EnhancedParamsDiff.checkMovedParam(builder, cleanQueue, dirtyQueue, 0)) {
                    return true;
                }
                if (cleanQueue.size() > 2 && dirtyQueue.size() > 2 && cleanQueue.get(1).matches(dirtyQueue.get(0)) && cleanQueue.get(2).matches(dirtyQueue.get(1))) {
                    builder.remove(cleanQueue.getFirst().pos());
                    cleanQueue.removeFirst();
                    return true;
                }
                return false;
            }
            return true;
        }
        if (cleanQueue.size() > 1 && dirtyQueue.size() > 1) {
            if (cleanQueue.get(0).sameType(dirtyQueue.get(0))) {
                if (cleanQueue.get(1).matches(dirtyQueue.get(1))) {
                    return true;
                }
                if (compareNames) {
                    if (dirtyQueue.size() > 2 && cleanQueue.get(1).matches(dirtyQueue.get(2))) {
                        builder.insert(dirtyQueue.get(1).pos(), dirtyQueue.get(1).type());
                        cleanQueue.removeFirst();
                        dirtyQueue.removeFirst();
                        dirtyQueue.removeFirst();
                        return true;
                    }
                } else {
                    return EnhancedParamsDiff.checkMovedParam(builder, cleanQueue, dirtyQueue, 1);
                }
            }
            return false;
        }
        return false;
    }

    private static boolean checkMovedParam(ParamsDiffSnapshotBuilder builder, List<TypeWithContext> cleanQueue, List<TypeWithContext> dirtyQueue, int index) {
        TypeWithContext param = cleanQueue.get(index);
        TypeWithContext dirtyParam = dirtyQueue.get(index);
        Map<Type, Integer> cleanGroup = EnhancedParamsDiff.groupTypes(cleanQueue);
        Map<Type, Integer> dirtyGroup = EnhancedParamsDiff.groupTypes(dirtyQueue);
        if (cleanGroup.get(param.type()) == 1 && dirtyGroup.getOrDefault(param.type(), 0) == 1 && Objects.equals(cleanGroup.getOrDefault(dirtyParam.type(), 0), dirtyGroup.get(dirtyParam.type()))) {
            TypeWithContext newParam = dirtyQueue.stream().filter(t -> t.type().equals((Object)param.type())).findFirst().orElseThrow();
            if (Math.abs(param.pos() - newParam.pos()) == 1) {
                builder.swap(param.pos(), newParam.pos());
            } else {
                builder.move(param.pos(), newParam.pos());
            }
            cleanQueue.remove(param);
            dirtyQueue.remove(newParam);
            return true;
        }
        return false;
    }

    private static int findClosestMatch(List<TypeWithContext> cleanQueue, List<TypeWithContext> dirtyQueue) {
        for (TypeWithContext typeWithContext : cleanQueue) {
            int pos = EnhancedParamsDiff.lookAhead(dirtyQueue, typeWithContext);
            if (pos == -1) continue;
            return pos;
        }
        return -1;
    }

    private static boolean tryReplacingParams(ParamsDiffSnapshotBuilder builder, List<TypeWithContext> cleanQueue, List<TypeWithContext> dirtyQueue) {
        if (EnhancedParamsDiff.replaceType(builder, 0, cleanQueue, dirtyQueue)) {
            return true;
        }
        if (cleanQueue.size() == 2 && dirtyQueue.size() == 2) {
            if (cleanQueue.get(0).sameType(dirtyQueue.get(1)) && cleanQueue.get(1).sameType(dirtyQueue.get(0))) {
                builder.swap(dirtyQueue.get(0).pos(), dirtyQueue.get(1).pos());
                cleanQueue.clear();
                dirtyQueue.clear();
                return true;
            }
            return EnhancedParamsDiff.replaceType(builder, 1, cleanQueue, dirtyQueue);
        }
        return false;
    }

    private static boolean replaceType(ParamsDiffSnapshotBuilder builder, int index, List<TypeWithContext> cleanQueue, List<TypeWithContext> dirtyQueue) {
        if (index >= cleanQueue.size() || index >= dirtyQueue.size()) {
            return false;
        }
        TypeWithContext cleanType = cleanQueue.get(index);
        TypeWithContext dirtyType = dirtyQueue.get(index);
        int next = index + 1;
        if (cleanQueue.size() != dirtyQueue.size() && dirtyQueue.size() > next && cleanType.sameType(dirtyQueue.get(next)) || EnhancedParamsDiff.isPossiblyInjected(next, cleanQueue, dirtyQueue)) {
            return false;
        }
        if (!cleanType.sameType(dirtyType)) {
            if (DEBUG) {
                LOGGER.info("Replacing {} with {}", (Object)cleanType, (Object)dirtyType);
            }
            cleanQueue.remove(index);
            dirtyQueue.remove(index);
            builder.replace(dirtyType.pos(), dirtyType.type());
            return true;
        }
        return false;
    }

    private static boolean isPossiblyInjected(int index, List<TypeWithContext> cleanQueue, List<TypeWithContext> dirtyQueue) {
        for (int i = index; i < cleanQueue.size() && i < dirtyQueue.size(); ++i) {
            if (cleanQueue.get(i).sameType(dirtyQueue.get(i))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static SwapResult checkForSwaps(ParamsDiffSnapshotBuilder builder, List<TypeWithContext> clean, List<TypeWithContext> dirty) {
        Map<Type, Integer> cleanGroup = EnhancedParamsDiff.groupTypes(clean);
        Map<Type, Integer> dirtyGroup = EnhancedParamsDiff.groupTypes(dirty);
        MapDifference diff = Maps.difference(cleanGroup, dirtyGroup);
        ArrayList<TypeWithContext> rearrangeClean = new ArrayList<TypeWithContext>(clean);
        ArrayList<TypeWithContext> rearrangeDirty = new ArrayList<TypeWithContext>(dirty);
        ArrayList<TypeWithContext> removeDirty = new ArrayList<TypeWithContext>();
        SimpleParamsDiffSnapshot.Builder tempDiff = SimpleParamsDiffSnapshot.builder();
        if (diff.entriesOnlyOnLeft().isEmpty() && !diff.entriesOnlyOnRight().isEmpty()) {
            for (Map.Entry entry : diff.entriesOnlyOnRight().entrySet()) {
                type = (Type)entry.getKey();
                count = (Integer)entry.getValue();
                if (count != 1) continue;
                inserted = dirty.stream().filter(t -> t.type().equals((Object)type)).findFirst().orElseThrow();
                dirtyGroup.remove(type);
                rearrangeDirty.remove(inserted);
                removeDirty.add(inserted);
                int offset = inserted.pos() + (int)builder.getRemovals().stream().filter(i -> i < inserted.pos()).count();
                tempDiff.insert(offset, inserted.type());
            }
        } else if (!diff.entriesOnlyOnLeft().isEmpty() && diff.entriesOnlyOnRight().isEmpty()) {
            for (Map.Entry entry : diff.entriesOnlyOnLeft().entrySet()) {
                type = (Type)entry.getKey();
                count = (Integer)entry.getValue();
                if (count != 1) continue;
                inserted = clean.stream().filter(t -> t.type().equals((Object)type)).findFirst().orElseThrow();
                tempDiff.remove(inserted.pos());
                cleanGroup.remove(type);
                rearrangeClean.remove(inserted);
            }
        }
        if (!EnhancedParamsDiff.sameTypeCount(cleanGroup, dirtyGroup)) {
            return null;
        }
        if (DEBUG) {
            LOGGER.info("Checking for swaps in parameters:\n{}", (Object)EnhancedParamsDiff.printTable(rearrangeClean, rearrangeDirty));
        }
        while (!rearrangeClean.isEmpty() && ((TypeWithContext)rearrangeClean.getFirst()).sameType((TypeWithContext)rearrangeDirty.getFirst())) {
            rearrangeClean.removeFirst();
            rearrangeDirty.removeFirst();
        }
        while (!rearrangeClean.isEmpty() && ((TypeWithContext)rearrangeClean.getLast()).sameType((TypeWithContext)rearrangeDirty.getLast())) {
            rearrangeClean.removeLast();
            rearrangeDirty.removeLast();
        }
        if (!rearrangeClean.isEmpty() && !rearrangeDirty.isEmpty()) {
            builder.merge(tempDiff.build());
            EnhancedParamsDiff.rearrange(builder, rearrangeClean, rearrangeDirty);
            return new SwapResult(removeDirty);
        }
        if (rearrangeClean.isEmpty() && rearrangeDirty.isEmpty()) {
            builder.merge(tempDiff.build());
            return new SwapResult(removeDirty);
        }
        return null;
    }

    private static void rearrange(ParamsDiffSnapshotBuilder builder, List<TypeWithContext> clean, List<TypeWithContext> dirty) {
        Map<Type, Integer> dirtyGroup;
        Map<Type, Integer> cleanGroup = EnhancedParamsDiff.groupTypes(clean);
        if (!EnhancedParamsDiff.sameTypeCount(cleanGroup, dirtyGroup = EnhancedParamsDiff.groupTypes(dirty))) {
            return;
        }
        if (DEBUG) {
            LOGGER.info("Rearranging parameters:\n{}", (Object)EnhancedParamsDiff.printTable(clean, dirty));
        }
        record Rearrangement(TypeWithContext cleanType, TypeWithContext dirtyType, int fromRelative, int toRelative) {
        }
        ArrayList<Rearrangement> rearrangements = new ArrayList<Rearrangement>();
        for (TypeWithContext cleanType : clean) {
            if (cleanGroup.get(cleanType.type()) != 1 || dirtyGroup.get(cleanType.type()) != 1) continue;
            TypeWithContext dirtyType = dirty.stream().filter(cleanType::sameType).findFirst().orElseThrow();
            rearrangements.add(new Rearrangement(cleanType, dirtyType, clean.indexOf(cleanType), dirty.indexOf(dirtyType)));
        }
        rearrangements.sort(Comparator.comparingInt(Rearrangement::toRelative));
        ArrayList<TypeWithContext> rearrangeClean = new ArrayList<TypeWithContext>(clean);
        ArrayList<TypeWithContext> rearrangeDirty = new ArrayList<TypeWithContext>(dirty);
        for (Rearrangement rearrangement : rearrangements) {
            int destPos;
            int offsetOriginalPos;
            boolean same = true;
            for (int i = 0; i < rearrangeClean.size(); ++i) {
                if (((TypeWithContext)rearrangeClean.get(i)).sameType((TypeWithContext)rearrangeDirty.get(i))) continue;
                same = false;
            }
            if (same) break;
            if (DEBUG) {
                LOGGER.info("Moving param {} to index {}", (Object)rearrangement.cleanType(), (Object)rearrangement.dirtyType().pos());
            }
            if (Math.abs((offsetOriginalPos = ((TypeWithContext)rearrangeDirty.get(rearrangement.fromRelative())).pos()) - (destPos = rearrangement.dirtyType().pos())) == 1) {
                builder.swap(offsetOriginalPos, destPos);
            } else {
                builder.move(offsetOriginalPos, destPos);
            }
            rearrangeClean.add(rearrangement.toRelative(), (TypeWithContext)rearrangeClean.remove(rearrangement.fromRelative()));
        }
    }

    private static void compare(ParamsDiffSnapshotBuilder builder, List<TypeWithContext> clean, List<TypeWithContext> dirty) {
        if (DEBUG) {
            LOGGER.info("Running comparison for:\n{}", (Object)EnhancedParamsDiff.printTable(clean, dirty));
        }
        List<ParametersDiff.MethodParameter> cleanTypes = clean.stream().map(t -> new ParametersDiff.MethodParameter(t.type(), t.isGenerated())).toList();
        List<ParametersDiff.MethodParameter> dirtyTypes = dirty.stream().map(t -> new ParametersDiff.MethodParameter(t.type(), t.isGenerated())).toList();
        ParametersDiff diff = ParametersDiff.compareParameters(cleanTypes, dirtyTypes, false);
        if (DEBUG) {
            LOGGER.info("Comparison results:\n\tInserted: {}\n\tReplaced: {}\n\tSwapped:  {}\n\tRemoved:  {}", new Object[]{diff.insertions(), diff.removals(), diff.swaps(), diff.removals()});
        }
        int indexOffset = !dirty.isEmpty() ? dirty.getFirst().pos() : 0;
        builder.merge(SimpleParamsDiffSnapshot.create(diff), indexOffset);
    }

    private static List<TypeWithContext> createPositionedList(List<Type> list) {
        ArrayList<TypeWithContext> ret = new ArrayList<TypeWithContext>();
        for (int i = 0; i < list.size(); ++i) {
            ret.add(new TypeWithContext(list.get(i), i));
        }
        return ret;
    }

    private static List<TypeWithContext> createPositionedVariableList(List<LocalVariable> list) {
        ArrayList<TypeWithContext> ret = new ArrayList<TypeWithContext>();
        for (int i = 0; i < list.size(); ++i) {
            LocalVariable ctx = list.get(i);
            ret.add(new TypeWithContext(ctx.name(), ctx.type(), i, ctx.isGenerated()));
        }
        return ret;
    }

    private static boolean sameTypeCount(Map<Type, Integer> cleanGroup, Map<Type, Integer> dirtyGroup) {
        if (cleanGroup.size() != dirtyGroup.size()) {
            return false;
        }
        for (Map.Entry<Type, Integer> entry : cleanGroup.entrySet()) {
            Integer dirtyCount = dirtyGroup.get(entry.getKey());
            if (dirtyCount != null && dirtyCount.intValue() == entry.getValue().intValue()) continue;
            return false;
        }
        return true;
    }

    private static <T> List<T> extract(List<T> list, int amount) {
        ArrayList<T> res = new ArrayList<T>();
        for (int i = 0; i < amount && !list.isEmpty(); ++i) {
            res.add(list.removeFirst());
        }
        return res;
    }

    private static int lookAhead(List<TypeWithContext> types, TypeWithContext target) {
        for (int i = 0; i < types.size(); ++i) {
            if (!target.sameType(types.get(i))) continue;
            return i;
        }
        return -1;
    }

    private static Map<Type, Integer> groupTypes(List<TypeWithContext> list) {
        HashMap<Type, Integer> map = new HashMap<Type, Integer>();
        for (TypeWithContext type : list) {
            map.compute(type.type(), (t, old) -> old == null ? 1 : old + 1);
        }
        return map;
    }

    private static String printTable(List<TypeWithContext> clean, List<TypeWithContext> dirty) {
        StringBuilder builder = new StringBuilder();
        builder.append("\t| %5s | %25s%s%26s | %25s%s%26s |\n".formatted("Index", "", "Clean", "", "", "Dirty", ""));
        builder.append("\t");
        builder.append("=".repeat(127));
        builder.append("\n");
        int max = Math.max(clean.size(), dirty.size());
        for (int i = 0; i < max; ++i) {
            builder.append("\t| %-5s | %56s | %-56s |\n".formatted(i, i < clean.size() ? clean.get(i).type() : "", i < dirty.size() ? dirty.get(i).type() : ""));
        }
        builder.append("\t");
        builder.append("=".repeat(127));
        return builder.toString();
    }

    private record SwapResult(List<TypeWithContext> removeDirty) {
    }

    private record TypeWithContext(@Nullable String name, Type type, int pos, boolean isGenerated) {
        public TypeWithContext(Type type, int pos) {
            this(null, type, pos, false);
        }

        public boolean sameType(TypeWithContext other) {
            return this.type().equals((Object)other.type());
        }

        public boolean sameName(TypeWithContext other) {
            return this.name == null || other.name() == null || this.isGenerated == other.isGenerated();
        }

        public boolean matches(TypeWithContext other) {
            return this.sameType(other) && this.sameName(other);
        }
    }

    private record LocalVariable(@Nullable String name, Type type, boolean isGenerated) {
        public LocalVariable(LocalVariableNode lvn) {
            this(lvn.name, Type.getType((String)lvn.desc), lvn.name != null && GeneratedVariables.isGeneratedVariableName(lvn.name, Type.getType((String)lvn.desc)));
        }
    }
}

