/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynfix;

import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MixinClassGenerator;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.MethodQualifier;

public final class SplitMethodCancellationHelper {
    public static void handle(Object transform, MethodContext methodContext, MethodNode newTarget) {
        MethodContext.TargetPair originalTarget = methodContext.findDirtyInjectionTarget();
        ClassNode originalClassTarget = originalTarget.classNode();
        MethodNode originalMethodTarget = originalTarget.methodNode();
        if (!MethodCallAnalyzer.isDirtyDeprecatedMethod(methodContext.findCleanInjectionTarget().methodNode(), originalMethodTarget) || Type.getReturnType((String)originalMethodTarget.desc) != Type.VOID_TYPE) {
            return;
        }
        MixinClassGenerator generator = methodContext.patchContext().environment().classGenerator();
        ClassNode generatedTarget = generator.getOrGenerateMixinClass(methodContext.getMixinClass(), originalClassTarget.name, null);
        List<MethodNode> invocations = MethodCallAnalyzer.collectMethodInvocations(originalClassTarget, originalMethodTarget);
        if (invocations == null) {
            return;
        }
        int index = invocations.indexOf(newTarget);
        String fieldName = "adapter$canceller$" + originalMethodTarget.name + "$" + AdapterUtil.randomString(5);
        FieldNode trackerField = (FieldNode)generatedTarget.visitField(2, fieldName, Type.BOOLEAN_TYPE.getDescriptor(), null, null);
        for (int i = index + 1; i < invocations.size(); ++i) {
            SplitMethodCancellationHelper.generateCancellerMethod(generatedTarget, trackerField, originalClassTarget, invocations.get(i), methodContext, i == invocations.size() - 1);
        }
        methodContext.recordAudit(transform, "Generate cancellation handler mixin", new Object[0]);
    }

    private static void generateCancellerMethod(ClassNode generatedTarget, FieldNode trackerField, ClassNode originalClassTarget, MethodNode newTarget, MethodContext methodContext, boolean reset) {
        String name = methodContext.getMixinMethod().name + "$adapter$canceller$" + AdapterUtil.randomString(5);
        String desc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{AdapterUtil.CI_TYPE});
        MethodNode invokerMixinMethod = (MethodNode)generatedTarget.visitMethod(2 | (methodContext.isStatic() ? 8 : 0), name, desc, null, null);
        AnnotationVisitor injectAnn = invokerMixinMethod.visitAnnotation("Lorg/spongepowered/asm/mixin/injection/Inject;", true);
        AnnotationVisitor methodValue = injectAnn.visitArray("method");
        methodValue.visit(null, (Object)(newTarget.name + newTarget.desc));
        methodValue.visitEnd();
        AnnotationVisitor atValue = injectAnn.visitArray("at");
        AnnotationVisitor atAnn = atValue.visitAnnotation(null, "Lorg/spongepowered/asm/mixin/injection/At;");
        atAnn.visit("value", (Object)"HEAD");
        atAnn.visitEnd();
        atValue.visitEnd();
        injectAnn.visit("cancellable", (Object)Boolean.TRUE);
        injectAnn.visitEnd();
        GeneratorAdapter gen = new GeneratorAdapter((MethodVisitor)invokerMixinMethod, invokerMixinMethod.access, invokerMixinMethod.name, invokerMixinMethod.desc);
        Label endLabel = new Label();
        gen.newLabel();
        gen.loadThis();
        gen.getField(Type.getObjectType((String)generatedTarget.name), trackerField.name, Type.BOOLEAN_TYPE);
        gen.visitJumpInsn(153, endLabel);
        if (reset) {
            gen.newLabel();
            gen.loadThis();
            gen.visitInsn(3);
            gen.putField(Type.getObjectType((String)generatedTarget.name), trackerField.name, Type.BOOLEAN_TYPE);
        }
        gen.newLabel();
        gen.loadArg(0);
        gen.invokeVirtual(AdapterUtil.CI_TYPE, new Method("cancel", "()V"));
        gen.visitLabel(endLabel);
        gen.returnValue();
        gen.newLabel();
        gen.endMethod();
        MethodQualifier qualifier = new MethodQualifier(AdapterUtil.CI_TYPE.getDescriptor(), "cancel", "()V");
        InsnList methodInsns = methodContext.getMixinMethod().instructions;
        for (AbstractInsnNode insn : methodInsns) {
            MethodInsnNode minsn;
            if (!(insn instanceof MethodInsnNode) || !qualifier.matches(minsn = (MethodInsnNode)insn)) continue;
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new InsnNode(4));
            list.add((AbstractInsnNode)new FieldInsnNode(181, originalClassTarget.name, trackerField.name, trackerField.desc));
            methodInsns.insertBefore((AbstractInsnNode)minsn, list);
        }
    }
}

