/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.operation.param;

import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.locals.LVTSnapshot;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.transformer.operation.param.ParamTransformationUtil;
import org.sinytra.adapter.patch.transformer.operation.param.ParameterTransformer;
import org.sinytra.adapter.patch.util.AdapterUtil;

public record RemoveParameterTransformer(int index, boolean upgradeWrapOperation) implements ParameterTransformer
{
    public RemoveParameterTransformer(int index) {
        this(index, true);
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context, List<Type> parameters, int offset) {
        int target = this.index() + offset;
        int lvtIndex = ParamTransformationUtil.calculateLVTIndex(parameters, !methodContext.isStatic(), target);
        if (this.upgradeWrapOperation) {
            ParamTransformationUtil.extractWrapOperation(methodContext, methodNode, parameters, op -> op.removeParameter(target));
        }
        LVTSnapshot.with(methodNode, () -> {
            LocalVariableNode lvn = methodNode.localVariables.stream().filter(v -> v.index == lvtIndex).findFirst().orElse(null);
            if (lvn != null) {
                methodNode.localVariables.remove(lvn);
                AdapterUtil.replaceLVT(methodNode, idx -> idx == lvtIndex ? -1 : idx);
            }
        });
        methodNode.parameters.remove(target);
        methodNode.visibleParameterAnnotations = AdapterUtil.removeArrayElement(methodNode.visibleParameterAnnotations, this.index, List[]::new);
        methodNode.invisibleParameterAnnotations = AdapterUtil.removeArrayElement(methodNode.invisibleParameterAnnotations, this.index, List[]::new);
        parameters.remove(target);
        return Patch.Result.COMPUTE_FRAMES;
    }
}

