/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.operation.unit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;

public record ModifyMethodAccess(List<AccessChange> changes) implements MethodTransform
{
    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        Patch.Result result = Patch.Result.PASS;
        for (AccessChange change : this.changes) {
            if (change.add) {
                if ((methodNode.access & change.modifier) != 0) continue;
                methodContext.recordAudit(this, "Adding access modifier %s", change.modifier);
                methodNode.access |= change.modifier;
                result = Patch.Result.APPLY;
                if (change.modifier != 8 || !methodContext.methodAnnotation().matchesDesc("Lorg/spongepowered/asm/mixin/injection/Inject;")) continue;
                List<Type> types = methodContext.targetTypes();
                if (types.size() == 1) {
                    Type[] params = Type.getArgumentTypes((String)methodNode.desc);
                    ArrayList<Type> newParams = new ArrayList<Type>(Arrays.asList(params));
                    newParams.addFirst(types.getFirst());
                    methodContext.updateDescription(this, newParams);
                    continue;
                }
                throw new IllegalStateException("Cannot automatically determine target instance type for mixin " + classNode.name);
            }
            if ((methodNode.access & change.modifier) == 0) continue;
            methodContext.recordAudit(this, "Removing access modifier %s", change.modifier);
            methodNode.access &= ~change.modifier;
            if (change.modifier == 8) {
                LocalVariableNode firstParam = methodNode.localVariables.stream().filter(lvn -> lvn.index == 0).findFirst().orElseThrow();
                for (LocalVariableNode lvn2 : methodNode.localVariables) {
                    ++lvn2.index;
                }
                for (AbstractInsnNode insn : methodNode.instructions) {
                    if (!(insn instanceof VarInsnNode)) continue;
                    VarInsnNode varInsn = (VarInsnNode)insn;
                    ++varInsn.var;
                }
                methodNode.localVariables.add(new LocalVariableNode("this", Type.getObjectType((String)classNode.name).getDescriptor(), null, firstParam.start, firstParam.end, 0));
                result = Patch.Result.COMPUTE_FRAMES;
                continue;
            }
            result = Patch.Result.APPLY;
        }
        return result;
    }

    public record AccessChange(boolean add, int modifier) {
    }
}

