/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.locator.filter;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarContentsBuilder;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.niofs.union.UnionPathFilter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jetbrains.annotations.Nullable;
import org.sinytra.connector.locator.filter.PackageTracker;
import org.sinytra.connector.transformer.jar.JarTransformer;
import org.slf4j.Logger;

public class SplitPackageMerger {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final UnionPathFilter BASE_FILTER = (path, basePath) -> !path.startsWith("META-INF/versions");

    public static List<FilteredModPath> mergeSplitPackages(List<JarTransformer.FabricModPath> paths, Iterable<IModFile> existing, Collection<? super IModFile> ignoredModFiles) {
        ArrayList<JarTransformer.FabricModPath> plainPaths = new ArrayList<JarTransformer.FabricModPath>(paths);
        ArrayList<FilteredModPath> output = new ArrayList<FilteredModPath>();
        HashMap<String, List> pkgSources = new HashMap<String, List>();
        for (JarTransformer.FabricModPath modInfo : paths) {
            SecureJar secureJar = SecureJar.from((Path[])new Path[]{modInfo.path()});
            for (String pkg2 : secureJar.moduleDataProvider().descriptor().packages()) {
                pkgSources.computeIfAbsent(pkg2, p -> new ArrayList()).add(Pair.of((Object)secureJar, (Object)modInfo));
            }
        }
        ArrayList jarOrder = new ArrayList();
        LinkedHashMap<String, List> mergePkgs = new LinkedHashMap<String, List>();
        AtomicInteger totalJars = new AtomicInteger(0);
        pkgSources.forEach((pkg, sources) -> {
            if (sources.size() > 1) {
                LOGGER.debug("Found split package {} in jars {}", pkg, (Object)sources.stream().map(info -> ((SecureJar)info.getFirst()).name()).collect(Collectors.joining(",")));
                sources.forEach(source -> {
                    if (plainPaths.remove(source.getSecond())) {
                        totalJars.getAndIncrement();
                    }
                    mergePkgs.computeIfAbsent((String)pkg, p -> new ArrayList()).add(source);
                    jarOrder.add((SecureJar)source.getFirst());
                });
            }
        });
        LOGGER.debug("Found {} split packages across {} jars", (Object)mergePkgs.keySet().size(), (Object)totalJars.get());
        HashMap<String, JarMergeInfo> jarMap = new HashMap<String, JarMergeInfo>();
        mergePkgs.forEach((pkg, sources) -> {
            sources.sort(Comparator.comparingInt(p -> jarOrder.indexOf(p.getFirst())));
            Pair pair = (Pair)sources.get(0);
            SecureJar candidate = (SecureJar)pair.getFirst();
            String name = candidate.name();
            JarMergeInfo owner = jarMap.computeIfAbsent(name, str -> new JarMergeInfo(candidate, ((JarTransformer.FabricModPath)pair.getSecond()).metadata()));
            SplitPackageMerger.analyzeJar(jarMap, owner, sources.subList(1, sources.size()), pkg);
        });
        HashSet<String> existingPackages = new HashSet<String>();
        for (IModFile modFile : existing) {
            if (ignoredModFiles.contains(modFile)) continue;
            existingPackages.addAll(modFile.getSecureJar().moduleDataProvider().descriptor().packages());
        }
        Set<IModuleLayerManager.Layer> layers = Set.of(IModuleLayerManager.Layer.BOOT, IModuleLayerManager.Layer.SERVICE);
        IModuleLayerManager manager = (IModuleLayerManager)Launcher.INSTANCE.findLayerManager().orElseThrow();
        for (IModuleLayerManager.Layer layer : layers) {
            ((ModuleLayer)manager.getLayer(layer).orElseThrow()).modules().stream().flatMap(module -> module.getPackages().stream()).forEach(existingPackages::add);
        }
        for (String pkg3 : existingPackages) {
            List list = (List)pkgSources.get(pkg3);
            if (list == null) continue;
            for (Pair pair : list) {
                SecureJar jar = (SecureJar)pair.getFirst();
                JarTransformer.FabricModPath modPath = (JarTransformer.FabricModPath)pair.getSecond();
                plainPaths.remove(modPath);
                JarMergeInfo info2 = jarMap.computeIfAbsent(jar.name(), str -> new JarMergeInfo(jar, modPath.metadata()));
                LOGGER.debug("Excluding existing package {} from jar {}", (Object)pkg3, (Object)jar.name());
                info2.excludedPackages().add(pkg3);
            }
        }
        jarMap.values().forEach(info -> {
            Set<Path> additionalPaths = info.additionalPaths();
            Set<String> excludedPackages = info.excludedPackages();
            PackageTracker filter = !excludedPackages.isEmpty() ? new PackageTracker(Set.copyOf(excludedPackages)) : null;
            Path[] jarPaths = (Path[])Stream.concat(Stream.of(info.jar().getPrimaryPath()), additionalPaths.stream()).toArray(Path[]::new);
            output.add(new FilteredModPath(jarPaths, SplitPackageMerger.mergeANDFilter(BASE_FILTER, filter), info.metadata));
        });
        for (JarTransformer.FabricModPath modPath : plainPaths) {
            output.add(new FilteredModPath(new Path[]{modPath.path()}, BASE_FILTER, modPath.metadata()));
        }
        if (paths.size() != output.size()) {
            LOGGER.error("Expected {} paths, got {}", (Object)paths.size(), (Object)plainPaths.size());
            throw new IllegalStateException("Path size disprenancy detected!");
        }
        return output;
    }

    private static void analyzeJar(Map<String, JarMergeInfo> swap, JarMergeInfo master, List<Pair<SecureJar, JarTransformer.FabricModPath>> others, String pkg) {
        List additionalPaths = others.stream().flatMap(pair -> {
            SecureJar sj = (SecureJar)pair.getFirst();
            JarTransformer.FabricModFileMetadata metadata = ((JarTransformer.FabricModPath)pair.getSecond()).metadata();
            JarContents jarContents = new JarContentsBuilder().paths(new Path[]{sj.getPrimaryPath()}).pathFilter(SplitPackageMerger.singlePackageFilter(pkg)).build();
            SecureJar singlePackage = SecureJar.from((JarContents)jarContents);
            JarMergeInfo jarInfo = swap.computeIfAbsent(sj.name(), name -> new JarMergeInfo(sj, metadata));
            jarInfo.excludedPackages().add(pkg);
            return Stream.of(singlePackage.getRootPath());
        }).toList();
        master.additionalPaths().addAll(additionalPaths);
    }

    private static UnionPathFilter singlePackageFilter(String pkg) {
        return (path, basePath) -> {
            int idx = path.lastIndexOf(47);
            return path.equals("/") || idx == path.length() - 1 || idx > -1 && pkg.equals(path.substring(0, idx).replace('/', '.'));
        };
    }

    private static UnionPathFilter mergeANDFilter(UnionPathFilter left, @Nullable UnionPathFilter right) {
        return (a, b) -> left.test(a, b) && (right == null || right.test(a, b));
    }

    private record JarMergeInfo(SecureJar jar, JarTransformer.FabricModFileMetadata metadata, Set<Path> additionalPaths, Set<String> excludedPackages) {
        public JarMergeInfo(SecureJar jar, JarTransformer.FabricModFileMetadata metadata) {
            this(jar, metadata, new HashSet<Path>(), new HashSet<String>());
        }
    }

    public record FilteredModPath(Path[] paths, @Nullable UnionPathFilter filter, JarTransformer.FabricModFileMetadata metadata) {
    }
}

