/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import me.pepperbell.continuity.api.client.CachingPredicates;
import me.pepperbell.continuity.api.client.CtmLoader;
import me.pepperbell.continuity.api.client.CtmLoaderRegistry;
import me.pepperbell.continuity.api.client.CtmProperties;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.model.QuadProcessors;
import me.pepperbell.continuity.client.resource.InvalidIdentifierStateHolder;
import me.pepperbell.continuity.client.util.BooleanState;
import me.pepperbell.continuity.client.util.biome.BiomeHolderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;

public class CtmPropertiesLoader {
    private final ResourceManager resourceManager;
    private final List<LoadingContainer<?>> containers = new ObjectArrayList();
    private final Map<ResourceLocation, Set<ResourceLocation>> textureDependencies = new Object2ObjectOpenHashMap();

    private CtmPropertiesLoader(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public static LoadingResult loadAllWithState(ResourceManager resourceManager) {
        BiomeHolderManager.clearCache();
        LoadingResult result = CtmPropertiesLoader.loadAll(resourceManager);
        BiomeHolderManager.refreshHolders();
        return result;
    }

    public static LoadingResult loadAll(ResourceManager resourceManager) {
        return new CtmPropertiesLoader(resourceManager).loadAll();
    }

    private LoadingResult loadAll() {
        int packPriority = 0;
        Iterator iterator = this.resourceManager.listPacks().iterator();
        BooleanState invalidIdentifierState = InvalidIdentifierStateHolder.get();
        invalidIdentifierState.enable();
        while (iterator.hasNext()) {
            PackResources pack = (PackResources)iterator.next();
            this.loadAll(pack, packPriority);
            ++packPriority;
        }
        invalidIdentifierState.disable();
        this.containers.sort(Comparator.reverseOrder());
        return new LoadingResult(this.containers, this.textureDependencies);
    }

    private void loadAll(PackResources pack, int packPriority) {
        for (String namespace : pack.getNamespaces(PackType.CLIENT_RESOURCES)) {
            pack.listResources(PackType.CLIENT_RESOURCES, namespace, "optifine/ctm", (resourceId, inputSupplier) -> {
                if (resourceId.getPath().endsWith(".properties")) {
                    try (InputStream stream = (InputStream)inputSupplier.get();){
                        Properties properties = new Properties();
                        properties.load(stream);
                        this.load(properties, (ResourceLocation)resourceId, pack, packPriority);
                    }
                    catch (Exception e) {
                        ContinuityClient.LOGGER.error("Failed to load CTM properties from file '" + String.valueOf(resourceId) + "' in pack '" + pack.packId() + "'", (Throwable)e);
                    }
                }
            });
        }
    }

    private void load(Properties properties, ResourceLocation resourceId, PackResources pack, int packPriority) {
        String method = properties.getProperty("method", "ctm").trim();
        CtmLoader<?> loader = CtmLoaderRegistry.get().getLoader(method);
        if (loader != null) {
            this.load(loader, properties, resourceId, pack, packPriority, method);
        } else {
            ContinuityClient.LOGGER.error("Unknown 'method' value '" + method + "' in file '" + String.valueOf(resourceId) + "' in pack '" + pack.packId() + "'");
        }
    }

    private <T extends CtmProperties> void load(CtmLoader<T> loader, Properties properties, ResourceLocation resourceId, PackResources pack, int packPriority, String method) {
        T ctmProperties = loader.getPropertiesFactory().createProperties(properties, resourceId, pack, packPriority, this.resourceManager, method);
        if (ctmProperties != null) {
            LoadingContainer<T> container = new LoadingContainer<T>(loader, ctmProperties);
            this.containers.add(container);
            for (Material spriteId : ctmProperties.getTextureDependencies()) {
                Set atlasTextureDependencies = this.textureDependencies.computeIfAbsent(spriteId.atlasLocation(), id -> new ObjectOpenHashSet());
                atlasTextureDependencies.add(spriteId.texture());
            }
        }
    }

    public static class LoadingResult {
        private final List<LoadingContainer<?>> containers;
        private final Map<ResourceLocation, Set<ResourceLocation>> textureDependencies;

        private LoadingResult(List<LoadingContainer<?>> containers, Map<ResourceLocation, Set<ResourceLocation>> textureDependencies) {
            this.containers = containers;
            this.textureDependencies = textureDependencies;
        }

        public List<QuadProcessors.ProcessorHolder> createProcessorHolders(Function<Material, TextureAtlasSprite> textureGetter) {
            ObjectArrayList processorHolders = new ObjectArrayList();
            for (LoadingContainer<?> container : this.containers) {
                processorHolders.add(container.toProcessorHolder(textureGetter));
            }
            return processorHolders;
        }

        public Map<ResourceLocation, Set<ResourceLocation>> getTextureDependencies() {
            return this.textureDependencies;
        }
    }

    private record LoadingContainer<T extends CtmProperties>(CtmLoader<T> loader, T properties) implements Comparable<LoadingContainer<?>>
    {
        public QuadProcessors.ProcessorHolder toProcessorHolder(Function<Material, TextureAtlasSprite> textureGetter) {
            QuadProcessor processor = this.loader.getProcessorFactory().createProcessor(this.properties, textureGetter);
            CachingPredicates predicates = this.loader.getPredicatesFactory().createPredicates(this.properties, textureGetter);
            return new QuadProcessors.ProcessorHolder(processor, predicates);
        }

        @Override
        public int compareTo(@NotNull LoadingContainer<?> o) {
            return this.properties.compareTo(o.properties);
        }
    }
}

