/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.sleepingbags.corelib.fluid;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class FluidUtils {
    public static boolean isFluidHandler(Level world, BlockPos pos, Direction direction) {
        return FluidUtils.getFluidHandler(world, pos, direction) != null;
    }

    public static boolean isFluidHandlerOffset(Level world, BlockPos pos, Direction direction) {
        return FluidUtils.getFluidHandlerOffset(world, pos, direction) != null;
    }

    @Nullable
    public static IFluidHandler getFluidHandler(Level world, BlockPos pos, Direction direction) {
        return (IFluidHandler)world.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)direction);
    }

    @Nullable
    public static IFluidHandler getFluidHandlerOffset(Level world, BlockPos pos, Direction direction) {
        return FluidUtils.getFluidHandler(world, pos.relative(direction), direction.getOpposite());
    }

    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer, @Nullable Fluid filter) {
        int fillableAmount;
        FluidStack drainable = filter == null ? fluidSource.drain(maxAmount, IFluidHandler.FluidAction.SIMULATE) : fluidSource.drain(new FluidStack(filter, maxAmount), IFluidHandler.FluidAction.SIMULATE);
        if (drainable.getAmount() > 0 && (fillableAmount = fluidDestination.fill(drainable, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            if (doTransfer) {
                FluidStack drained = filter == null ? fluidSource.drain(fillableAmount, IFluidHandler.FluidAction.EXECUTE) : fluidSource.drain(new FluidStack(filter, fillableAmount), IFluidHandler.FluidAction.EXECUTE);
                drained.setAmount(fluidDestination.fill(drained, IFluidHandler.FluidAction.EXECUTE));
                return drained;
            }
            drainable.setAmount(fillableAmount);
            return drainable;
        }
        return FluidStack.EMPTY;
    }

    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer) {
        return FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)fluidSource, (int)maxAmount, (boolean)doTransfer);
    }

    public static boolean tryFluidInteraction(Player player, InteractionHand hand, Level world, BlockPos pos) {
        ItemStack stack = player.getItemInHand(hand);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
        if (!fluidStack.isEmpty() && FluidUtils.handleEmpty((LevelAccessor)world, pos, player, hand)) {
            return true;
        }
        IFluidHandler handler = FluidUtil.getFluidHandler((ItemStack)stack).orElse(null);
        return handler != null && FluidUtils.handleFill((LevelAccessor)world, pos, player, hand);
    }

    public static boolean handleEmpty(LevelAccessor world, BlockPos pos, Player player, InteractionHand hand) {
        BlockEntity te = world.getBlockEntity(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)te;
        InvWrapper inv = new InvWrapper((Container)player.getInventory());
        ItemStack stack = player.getItemInHand(hand);
        FluidActionResult res = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
        if (res.isSuccess()) {
            player.setItemInHand(hand, res.result);
            return true;
        }
        return false;
    }

    public static boolean handleFill(LevelAccessor world, BlockPos pos, Player player, InteractionHand hand) {
        BlockEntity te = world.getBlockEntity(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler blockHandler = (IFluidHandler)te;
        InvWrapper inv = new InvWrapper((Container)player.getInventory());
        ItemStack stack = player.getItemInHand(hand);
        FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)blockHandler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
        if (result.isSuccess()) {
            player.setItemInHand(hand, result.result);
            return true;
        }
        return false;
    }
}

