/*
 * Decompiled with CFR 0.152.
 */
package me.pieking1215.dripsounds;

import com.google.common.util.concurrent.AtomicDouble;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import me.pieking1215.dripsounds.DripSounds;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.IntegerSliderEntry;
import me.shedaniel.clothconfig2.impl.builders.IntSliderBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;

public class DripSoundsConfig {
    public static final General GENERAL = new General();
    public static File configFile;

    public static Screen setupCloth(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)DripSounds.instance().translatableComponent("config.waterdripsound.general"));
        builder.setDefaultBackgroundTexture(DripSounds.instance().parseResource("minecraft:textures/block/mossy_stone_bricks.png"));
        builder.transparentBackground();
        ConfigEntryBuilder eb = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((Component)DripSounds.instance().translatableComponent("key.waterdripsound.category"));
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)DripSounds.instance().translatableComponent("config.waterdripsound.enable"), DripSoundsConfig.GENERAL.enabled.get()).setDefaultValue(true).setSaveConsumer(DripSoundsConfig.GENERAL.enabled::set).build());
        general.addEntry((AbstractConfigListEntry)eb.startIntSlider((Component)DripSounds.instance().translatableComponent("config.waterdripsound.volume"), (int)(DripSoundsConfig.GENERAL.volume.get() * 100.0), 0, 100).setDefaultValue(30).setTextGetter(integer -> DripSounds.instance().literalComponent("Volume: " + integer + "%")).setSaveConsumer(integer -> DripSoundsConfig.GENERAL.volume.set((double)integer.intValue() / 100.0)).build());
        general.addEntry((AbstractConfigListEntry)eb.startEnumSelector((Component)DripSounds.instance().translatableComponent("config.waterdripsound.soundCategory"), SoundSource.class, (Enum)DripSoundsConfig.GENERAL.soundCategory.get()).setDefaultValue((Enum)SoundSource.AMBIENT).setEnumNameProvider(anEnum -> DripSounds.instance().translatableComponent("soundCategory." + ((SoundSource)anEnum).getName())).setSaveConsumer(DripSoundsConfig.GENERAL.soundCategory::set).build());
        general.addEntry((AbstractConfigListEntry)eb.startIntSlider((Component)DripSounds.instance().translatableComponent("config.waterdripsound.dripChance"), DripSoundsConfig.GENERAL.dripChance.get(), 1, 100).setDefaultValue(10).setTextGetter(integer -> DripSounds.instance().literalComponent("One in " + integer)).setTooltip(new Component[]{DripSounds.instance().translatableComponent("tooltip.config.waterdripsound.dripChance")}).setSaveConsumer(DripSoundsConfig.GENERAL.dripChance::set).build());
        boolean blockAnimateEnabled = !DripSounds.instance().hasMod("effective");
        general.addEntry(DripSoundsConfig.handleDisabling(eb.startIntSlider((Component)DripSounds.instance().translatableComponent("config.waterdripsound.blockAnimateRangeMultiplier"), (int)(DripSoundsConfig.GENERAL.blockAnimateRangeMultiplier.get() / 0.25), 1, 16).setDefaultValue(4).setTextGetter(integer -> DripSounds.instance().literalComponent((float)integer.intValue() * 0.25f + "x (" + (int)((float)integer.intValue() * 0.25f * 32.0f) + " Blocks)")).setSaveConsumer(integer -> DripSoundsConfig.GENERAL.blockAnimateRangeMultiplier.set((double)integer.intValue() * 0.25)), () -> Optional.ofNullable(blockAnimateEnabled ? null : DripSounds.instance().translatableComponent("config.waterdripsound.blockAnimateNotSupported.effective")), DripSounds.instance().translatableComponent("tooltip.config.waterdripsound.blockAnimateRangeMultiplier")));
        general.addEntry(DripSoundsConfig.handleDisabling(eb.startIntSlider((Component)DripSounds.instance().translatableComponent("config.waterdripsound.blockAnimateCountMultiplier"), (int)(DripSoundsConfig.GENERAL.blockAnimateCountMultiplier.get() / 0.25), 0, 64).setDefaultValue(4).setTextGetter(integer -> DripSounds.instance().literalComponent((float)integer.intValue() * 0.25f + "x")).setSaveConsumer(integer -> DripSoundsConfig.GENERAL.blockAnimateCountMultiplier.set((double)integer.intValue() * 0.25)), () -> Optional.ofNullable(blockAnimateEnabled ? null : DripSounds.instance().translatableComponent("config.waterdripsound.blockAnimateNotSupported.effective")), DripSounds.instance().translatableComponent("tooltip.config.waterdripsound.blockAnimateCountMultiplier")));
        return builder.setSavingRunnable(DripSoundsConfig::save).build();
    }

    private static AbstractConfigListEntry<Integer> handleDisabling(IntSliderBuilder entry, Supplier<Optional<MutableComponent>> getDisable, MutableComponent normalTooltip) {
        Optional<MutableComponent> disableReason = getDisable.get();
        disableReason.ifPresent(c -> entry.setTooltip(new Component[]{DripSounds.instance().translatableComponent("config.waterdripsound.blockAnimateNotSupported"), c, DripSounds.instance().literalComponent(" "), normalTooltip}));
        IntegerSliderEntry built = entry.build();
        disableReason.ifPresent(arg_0 -> DripSoundsConfig.lambda$handleDisabling$11((AbstractConfigListEntry)built, arg_0));
        return built;
    }

    public static void save() {
        try {
            File configDir = DripSounds.instance().configDir();
            if (configDir != null) {
                File configFile = new File(configDir, "waterdripsound.json");
                if (!configFile.exists()) {
                    configFile.getParentFile().mkdirs();
                    configFile.createNewFile();
                }
                if (configFile.exists()) {
                    DripSoundsConfig.writeMainConfig(configFile);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void load() {
        try {
            File configDir = DripSounds.instance().configDir();
            if (configDir != null) {
                File configFile = new File(configDir, "waterdripsound.json");
                if (!configFile.exists()) {
                    configFile.getParentFile().mkdirs();
                    configFile.createNewFile();
                    if (configFile.exists()) {
                        DripSoundsConfig.writeMainConfig(configFile);
                    }
                }
                if (configFile.exists()) {
                    DripSoundsConfig.readMainConfig(configFile);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeMainConfig(File file) throws IOException {
        JsonWriter jw = new JsonWriter((Writer)new FileWriter(file));
        jw.setIndent("  ");
        jw.beginObject();
        jw.name("enabled").value(DripSoundsConfig.GENERAL.enabled.get());
        jw.name("volume").value(DripSoundsConfig.GENERAL.volume.get());
        jw.name("dripChance").value((long)DripSoundsConfig.GENERAL.dripChance.get());
        jw.name("useDripstoneSounds").value(DripSoundsConfig.GENERAL.useDripstoneSounds.get());
        jw.name("soundCategory").value(DripSoundsConfig.GENERAL.soundCategory.get().getName());
        jw.name("blockAnimateRangeMultiplier").value(DripSoundsConfig.GENERAL.blockAnimateRangeMultiplier.get());
        jw.name("blockAnimateCountMultiplier").value(DripSoundsConfig.GENERAL.blockAnimateCountMultiplier.get());
        jw.endObject();
        jw.close();
    }

    private static void readMainConfig(File file) throws IOException {
        JsonReader jr = new JsonReader((Reader)new FileReader(file));
        JsonElement jsonEl = (JsonElement)new Gson().fromJson(jr, JsonElement.class);
        jr.close();
        if (jsonEl != null) {
            JsonObject json = jsonEl.getAsJsonObject();
            if (json.has("enabled")) {
                DripSoundsConfig.GENERAL.enabled.set(json.get("enabled").getAsBoolean());
            }
            if (json.has("volume")) {
                DripSoundsConfig.GENERAL.volume.set(json.get("volume").getAsDouble());
            }
            if (json.has("dripChance")) {
                DripSoundsConfig.GENERAL.dripChance.set(json.get("dripChance").getAsInt());
            }
            if (json.has("useDripstoneSounds")) {
                DripSoundsConfig.GENERAL.useDripstoneSounds.set(json.get("useDripstoneSounds").getAsBoolean());
            }
            if (json.has("soundCategory")) {
                DripSoundsConfig.GENERAL.soundCategory.set(Arrays.stream(SoundSource.values()).filter(c -> c.getName().equals(json.get("soundCategory").getAsString())).findFirst().orElse(SoundSource.AMBIENT));
            }
            if (json.has("blockAnimateRangeMultiplier")) {
                DripSoundsConfig.GENERAL.blockAnimateRangeMultiplier.set(json.get("blockAnimateRangeMultiplier").getAsDouble());
            }
            if (json.has("blockAnimateCountMultiplier")) {
                DripSoundsConfig.GENERAL.blockAnimateCountMultiplier.set(json.get("blockAnimateCountMultiplier").getAsDouble());
            }
        }
    }

    private static /* synthetic */ void lambda$handleDisabling$11(AbstractConfigListEntry built, MutableComponent c) {
        built.setEditable(false);
    }

    public static class General {
        public final AtomicBoolean enabled = new AtomicBoolean(true);
        public final AtomicDouble volume = new AtomicDouble(0.3);
        public final AtomicInteger dripChance = new AtomicInteger(10);
        public final AtomicDouble blockAnimateRangeMultiplier = new AtomicDouble(1.0);
        public final AtomicDouble blockAnimateCountMultiplier = new AtomicDouble(1.0);
        public final AtomicBoolean useDripstoneSounds = new AtomicBoolean(true);
        public final AtomicReference<SoundSource> soundCategory = new AtomicReference<SoundSource>(SoundSource.AMBIENT);
    }
}

