/*
 * Decompiled with CFR 0.152.
 */
package me.pieking1215.dripsounds.mixin.client;

import me.pieking1215.dripsounds.DripSoundsConfig;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DripParticle.FallAndLandParticle.class})
public class MixinFallAndLandParticle {
    @Inject(method={"postMoveUpdate()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/particle/DripParticle$FallAndLandParticle;remove()V")})
    private void onLand(CallbackInfo ci) {
        if (DripSoundsConfig.GENERAL.enabled.get()) {
            DripParticle.FallAndLandParticle particle = (DripParticle.FallAndLandParticle)this;
            ClientLevel level = particle.level;
            double x = particle.x;
            double y = particle.y;
            double z = particle.z;
            Fluid particleFluid = particle.type;
            FluidState belowFluid = level.getBlockState(new BlockPos((int)x, (int)y - 1, (int)z)).getFluidState();
            SoundEvent play = null;
            float volumeMod = 1.0f;
            float pitch = 1.0f;
            if (particleFluid == Fluids.LAVA && belowFluid.getType() != Fluids.LAVA) {
                play = SoundEvents.POINTED_DRIPSTONE_DRIP_LAVA;
            } else if (particleFluid == Fluids.WATER && belowFluid.isEmpty()) {
                play = SoundEvents.POINTED_DRIPSTONE_DRIP_WATER;
            }
            if (play != null) {
                float vol = Mth.clamp((float)(DripSoundsConfig.GENERAL.volume.floatValue() * volumeMod), (float)0.0f, (float)1.0f);
                if (DripSoundsConfig.GENERAL.useDripstoneSounds.get()) {
                    vol = (float)((double)vol * (Math.random() * 0.7 + 0.3));
                }
                level.playLocalSound(x, y, z, play, DripSoundsConfig.GENERAL.soundCategory.get(), vol, pitch, false);
            }
        }
    }
}

