/*
 * Decompiled with CFR 0.152.
 */
package ru.tpsd.eatinganimationmod;

import java.util.ArrayList;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class EatingAnimationClientMod
implements ClientModInitializer {
    private static final ArrayList<Item> FOOD_ITEMS = new ArrayList<Item>(BuiltInRegistries.ITEM.stream().filter(p -> p.getDefaultInstance().getComponents().has(DataComponents.FOOD)).toList());

    public void onInitializeClient() {
        for (Item item : FOOD_ITEMS) {
            ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"eat"), (itemStack, clientWorld, livingEntity, i) -> {
                if (livingEntity == null) {
                    return 0.0f;
                }
                if (livingEntity instanceof RemotePlayer) {
                    if (itemStack.getUseDuration(livingEntity) > 16) {
                        return livingEntity.getUseItem() != itemStack ? 0.0f : (float)livingEntity.getTicksUsingItem() / (float)itemStack.getUseDuration(livingEntity) % 1.0f;
                    }
                    return livingEntity.getUseItem() != itemStack ? 0.0f : (float)livingEntity.getTicksUsingItem() / 32.0f % 0.5f;
                }
                return livingEntity.getUseItem() != itemStack ? 0.0f : (float)(itemStack.getUseDuration(livingEntity) - livingEntity.getUseItemRemainingTicks()) / 30.0f;
            });
            ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"eating"), (itemStack, clientWorld, livingEntity, i) -> {
                if (livingEntity == null) {
                    return 0.0f;
                }
                return livingEntity.isUsingItem() && livingEntity.getUseItem() == itemStack ? 1.0f : 0.0f;
            });
        }
        FabricLoader.getInstance().getModContainer("eatinganimationid").ifPresent(eatinganimation -> ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)EatingAnimationClientMod.locate("supporteatinganimation"), (ModContainer)eatinganimation, (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED));
    }

    public static ResourceLocation locate(String path) {
        return ResourceLocation.withDefaultNamespace((String)path);
    }

    static {
        FOOD_ITEMS.add(Items.MILK_BUCKET);
    }
}

