/*
 * Decompiled with CFR 0.152.
 */
package ru.tpsd.eatinganimationmod.mixin;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public abstract class DrawContextLegacyMixin
implements ResourceManagerReloadListener {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private PoseStack pose;
    @Shadow
    @Final
    private MultiBufferSource.BufferSource bufferSource;

    @Shadow
    public void flush() {
        RenderSystem.disableDepthTest();
        this.bufferSource.endBatch();
        RenderSystem.enableDepthTest();
    }

    @Shadow
    public MultiBufferSource.BufferSource bufferSource() {
        return this.bufferSource;
    }

    @Inject(method={"drawItem(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;IIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    void innerRenderInGui(LivingEntity entity, Level world, ItemStack stack, int x, int y, int seed, int z, CallbackInfo ci) {
        if (!stack.isEmpty() && stack.has(DataComponents.FOOD)) {
            boolean bl;
            BakedModel bakedModel = this.minecraft.getItemRenderer().getItemModelShaper().getItemModel(stack);
            this.pose.pushPose();
            this.pose.translate((float)(x + 8), (float)(y + 8), (float)(150 + (bakedModel.isGui3d() ? z : 0)));
            this.pose.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            this.pose.scale(16.0f, 16.0f, 16.0f);
            boolean bl2 = bl = !bakedModel.usesBlockLight();
            if (bl) {
                Lighting.setupForFlatItems();
            }
            this.minecraft.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, this.pose, (MultiBufferSource)this.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
            this.flush();
            if (bl) {
                Lighting.setupFor3DItems();
            }
            this.pose.popPose();
            ci.cancel();
        }
    }
}

