/*
 * Decompiled with CFR 0.152.
 */
package ru.tpsd.eatinganimationmod.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={GuiGraphics.class})
public abstract class DrawContextMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @ModifyVariable(method={"drawItem(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;IIII)V"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/render/item/ItemRenderer;getModel(Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/LivingEntity;I)Lnet/minecraft/client/render/model/BakedModel;"), ordinal=0)
    private BakedModel getModel(BakedModel bakedModel, @Nullable LivingEntity entity, @Nullable Level world, ItemStack stack, int x, int y, int seed, int z) {
        if (stack.has(DataComponents.FOOD) && stack.get(DataComponents.CUSTOM_MODEL_DATA) == null) {
            return this.getHeldFoodItemModel(stack, entity, seed);
        }
        return this.minecraft.getItemRenderer().getModel(stack, world, entity, seed);
    }

    @Unique
    public BakedModel getHeldFoodItemModel(ItemStack stack, @Nullable LivingEntity entity, int seed) {
        BakedModel currentItemBakedModel = this.minecraft.getItemRenderer().getItemModelShaper().getItemModel(stack);
        BakedModel itemBakedModel = stack.has(DataComponents.FOOD) ? this.minecraft.getItemRenderer().getItemModelShaper().getItemModel(stack) : currentItemBakedModel.getOverrides().resolve(currentItemBakedModel, stack, this.minecraft.level, entity, seed);
        return itemBakedModel == null ? this.minecraft.getItemRenderer().getItemModelShaper().getModelManager().getMissingModel() : itemBakedModel;
    }
}

