/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.waypoint;

import java.util.HashMap;
import java.util.Map;
import journeymap.common.waypoint.Settings;

public class GroupSettings
extends Settings {
    public boolean locked = false;
    public boolean colorOverride = false;
    private boolean iconOverride = false;
    private Map<String, String> displaySettings;

    public GroupSettings() {
        super(true, false, true);
        this.displaySettings = new HashMap<String, String>();
    }

    public GroupSettings(boolean enable, boolean showDeviation, boolean locked, boolean colorOverride, Map<String, String> displaySettings, boolean persistent) {
        super(enable, showDeviation, persistent);
        this.locked = locked;
        this.colorOverride = colorOverride;
        this.displaySettings = new HashMap<String, String>(displaySettings);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.markDirty();
    }

    public Map<String, String> getDisplaySettings() {
        return this.displaySettings;
    }

    public String getDisplaySetting(String key, String defaultValue) {
        String value = this.displaySettings.get(key);
        if (value == null) {
            this.setDisplaySetting(key, defaultValue);
            return defaultValue;
        }
        return value;
    }

    public boolean isColorOverride() {
        return this.colorOverride;
    }

    public void setColorOverride(boolean colorOverride) {
        this.colorOverride = colorOverride;
        this.markDirty();
    }

    public boolean isIconOverride() {
        return this.iconOverride;
    }

    public void setIconOverride(boolean iconOverride) {
        this.iconOverride = iconOverride;
        this.markDirty();
    }

    public String setDisplaySetting(String key, String value) {
        String setting = this.displaySettings.put(key, value);
        this.markDirty();
        return setting;
    }
}

