/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.List;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.MutableWaystone;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.component.ModComponents;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.item.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class WaystoneBlockBase
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<WaystoneOrigin> ORIGIN = EnumProperty.create((String)"origin", WaystoneOrigin.class);

    public WaystoneBlockBase(BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.BLOCK));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(ORIGIN, (Comparable)((Object)WaystoneOrigin.UNKNOWN)));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState directionState, LevelAccessor world, BlockPos pos, BlockPos directionPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (this.isDoubleBlock(state)) {
            DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
            if ((direction.getAxis() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (direction == Direction.UP) || directionState.getBlock() == this && directionState.getValue(HALF) != half) && (half != DoubleBlockHalf.LOWER || direction != Direction.DOWN || state.canSurvive((LevelReader)world, pos))) {
                return state;
            }
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        if (this.isDoubleBlock(state)) {
            super.playerDestroy(world, player, pos, Blocks.AIR.defaultBlockState(), blockEntity, stack);
        } else {
            super.playerDestroy(world, player, pos, state, blockEntity, stack);
        }
    }

    private boolean isDoubleBlock(BlockState state) {
        return state.hasProperty(HALF);
    }

    protected boolean canSilkTouch() {
        return false;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockState offsetState;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        boolean isDoubleBlock = this.isDoubleBlock(state);
        DoubleBlockHalf half = isDoubleBlock ? (DoubleBlockHalf)state.getValue(HALF) : null;
        BlockPos offset = half == DoubleBlockHalf.LOWER ? pos.above() : pos.below();
        BlockEntity offsetTileEntity = isDoubleBlock ? world.getBlockEntity(offset) : null;
        Boolean hasSilkTouch = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.SILK_TOUCH).map(it -> EnchantmentHelper.getEnchantmentLevel((Holder)it, (LivingEntity)player) > 0).orElse(false);
        if (hasSilkTouch.booleanValue() && this.canSilkTouch()) {
            if (blockEntity instanceof WaystoneBlockEntityBase) {
                ((WaystoneBlockEntityBase)blockEntity).setSilkTouched(true);
            }
            if (isDoubleBlock && offsetTileEntity instanceof WaystoneBlockEntityBase) {
                ((WaystoneBlockEntityBase)offsetTileEntity).setSilkTouched(true);
            }
        }
        if (isDoubleBlock && (offsetState = world.getBlockState(offset)).getBlock() == this && offsetState.getValue(HALF) != half) {
            world.destroyBlock(half == DoubleBlockHalf.LOWER ? pos : offset, false, (Entity)player);
            if (!world.isClientSide && !player.getAbilities().instabuild) {
                WaystoneBlockBase.dropResources((BlockState)state, (Level)world, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)player.getMainHandItem());
                WaystoneBlockBase.dropResources((BlockState)offsetState, (Level)world, (BlockPos)offset, (BlockEntity)offsetTileEntity, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)blockEntity;
            if (!player.getAbilities().instabuild) {
                for (int i = 0; i < waystoneBlockEntity.getContainer().getContainerSize(); ++i) {
                    ItemStack itemStack = waystoneBlockEntity.getContainer().getItem(i);
                    WaystoneBlockBase.popResource((Level)world, (BlockPos)pos, (ItemStack)itemStack);
                }
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, ORIGIN});
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (!this.isDoubleBlock(state)) {
            return true;
        }
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return true;
        }
        BlockState below = world.getBlockState(pos.below());
        return below.getBlock() == this && below.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        FluidState fluidState = world.getFluidState(pos);
        if (pos.getY() < world.getHeight() - 1 && world.getBlockState(pos.above()).canBeReplaced(context)) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER))).setValue(ORIGIN, (Comparable)((Object)WaystoneOrigin.PLAYER));
        }
        return null;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void notifyObserversOfAction(Level world, BlockPos pos) {
        if (!world.isClientSide) {
            for (Direction direction : Direction.values()) {
                BlockPos offset = pos.relative(direction);
                BlockState neighbourState = world.getBlockState(offset);
                Block neighbourBlock = neighbourState.getBlock();
                if (!(neighbourBlock instanceof ObserverBlock) || neighbourState.getValue((Property)ObserverBlock.FACING) != direction.getOpposite() || world.getBlockTicks().hasScheduledTick(offset, (Object)neighbourBlock)) continue;
                world.scheduleTick(offset, neighbourBlock, 2);
            }
        }
    }

    @Nullable
    protected InteractionResult handleEditActions(Level world, Player player, WaystoneBlockEntityBase blockEntity, Waystone waystone) {
        if (player.isShiftKeyDown()) {
            if (!world.isClientSide) {
                blockEntity.getSettingsMenuProvider().ifPresent(menuProvider -> Balm.getNetworking().openGui(player, menuProvider));
            }
            return InteractionResult.SUCCESS;
        }
        return null;
    }

    protected boolean shouldOpenMenuWhenPlaced() {
        return true;
    }

    @Nullable
    protected InteractionResult handleActivation(Level world, BlockPos pos, Player player, WaystoneBlockEntityBase tileEntity, Waystone waystone) {
        return null;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = world.getBlockEntity(pos)) instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)blockEntity;
            Waystone waystone = waystoneBlockEntity.getWaystone();
            boolean wasNotSilkTouched = !this.canSilkTouch() || !waystoneBlockEntity.isSilkTouched();
            WaystoneSyncManager.sendWaystoneRemovalToAll(world.getServer(), waystone, wasNotSilkTouched);
            if (wasNotSilkTouched) {
                WaystoneManagerImpl.get(world.getServer()).removeWaystone(waystone);
                PlayerWaystoneManager.removeKnownWaystone(world.getServer(), waystone);
            } else if (waystone instanceof MutableWaystone) {
                MutableWaystone mutableWaystone = (MutableWaystone)((Object)waystone);
                mutableWaystone.setTransient(true);
                WaystoneManagerImpl.get(world.getServer()).updateWaystone(waystone);
            }
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        WaystoneProxy waystone;
        super.appendHoverText(stack, context, list, flag);
        UUID waystoneUid = (UUID)stack.get((DataComponentType)ModComponents.waystone.get());
        if (waystoneUid != null && (waystone = new WaystoneProxy(null, waystoneUid)).isValid()) {
            this.addWaystoneNameToTooltip(list, waystone);
        }
    }

    protected void addWaystoneNameToTooltip(List<Component> tooltip, WaystoneProxy waystone) {
        tooltip.add((Component)waystone.getName().copy().withStyle(ChatFormatting.AQUA));
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (itemStack.is(ModItems.blankScroll)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useItemOn(itemStack, state, level, pos, player, hand, blockHitResult);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof WaystoneBlockEntityBase)) {
            return InteractionResult.FAIL;
        }
        WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)blockEntity;
        Waystone waystone = waystoneBlockEntity.getWaystone();
        InteractionResult result = this.handleEditActions(level, player, waystoneBlockEntity, waystone);
        if (result != null) {
            return result;
        }
        result = this.handleActivation(level, pos, player, waystoneBlockEntity, waystone);
        if (result != null) {
            return result;
        }
        return InteractionResult.FAIL;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        BlockPos posAbove = pos.above();
        boolean isDoubleBlock = this.isDoubleBlock(state);
        if (isDoubleBlock) {
            FluidState fluidStateAbove = world.getFluidState(posAbove);
            world.setBlockAndUpdate(posAbove, (BlockState)((BlockState)((BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidStateAbove.getType() == Fluids.WATER))).setValue(ORIGIN, (Comparable)((Object)WaystoneOrigin.PLAYER)));
        }
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            if (!world.isClientSide) {
                BlockEntity waystoneEntityAbove;
                Waystone waystone;
                UUID waystoneUid = (UUID)stack.get((DataComponentType)ModComponents.waystone.get());
                WaystoneProxy existingWaystone = null;
                if (waystoneUid != null) {
                    existingWaystone = new WaystoneProxy(world.getServer(), waystoneUid);
                }
                if (existingWaystone != null && existingWaystone.isValid() && (waystone = existingWaystone.getBackingWaystone()) instanceof WaystoneImpl) {
                    WaystoneImpl backingWaystone = (WaystoneImpl)waystone;
                    ((WaystoneBlockEntityBase)blockEntity).initializeFromExisting((ServerLevelAccessor)world, backingWaystone, stack);
                } else {
                    ((WaystoneBlockEntityBase)blockEntity).initializeWaystone((ServerLevelAccessor)world, placer, WaystoneOrigin.PLAYER);
                }
                if (isDoubleBlock && (waystoneEntityAbove = world.getBlockEntity(posAbove)) instanceof WaystoneBlockEntityBase) {
                    ((WaystoneBlockEntityBase)waystoneEntityAbove).initializeFromBase((WaystoneBlockEntityBase)blockEntity);
                }
            }
            if (placer instanceof Player) {
                Waystone waystone = ((WaystoneBlockEntityBase)blockEntity).getWaystone();
                PlayerWaystoneManager.activateWaystone((Player)placer, waystone);
                if (!world.isClientSide) {
                    WaystoneSyncManager.sendActivatedWaystones((Player)placer);
                }
            }
            if (!world.isClientSide && placer instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)placer;
                WaystoneBlockEntityBase waystoneTileEntity = (WaystoneBlockEntityBase)blockEntity;
                if (this.shouldOpenMenuWhenPlaced()) {
                    waystoneTileEntity.getSettingsMenuProvider().ifPresent(it -> Balm.getNetworking().openGui((Player)player, it));
                }
            }
        }
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

