/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.xppump;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum AutomationDirection implements StringRepresentable
{
    INPUT("input"),
    OUTPUT("output"),
    KEEP("keep"),
    OFF("off");

    public static final Codec<AutomationDirection> CODEC;
    public static final StreamCodec<FriendlyByteBuf, AutomationDirection> STREAM_CODEC;
    private final String name;
    private static final Map<String, AutomationDirection> NAME_VALUES;
    private static final AutomationDirection[] VALUES;

    private AutomationDirection(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public AutomationDirection next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static AutomationDirection fromName(String name) {
        return NAME_VALUES.getOrDefault(name, INPUT);
    }

    static {
        CODEC = StringRepresentable.fromEnum(AutomationDirection::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(AutomationDirection.class);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (AutomationDirection value : AutomationDirection.values()) {
            builder.put((Object)value.getSerializedName(), (Object)value);
        }
        NAME_VALUES = builder.build();
        VALUES = AutomationDirection.values();
    }
}

